#include "PascalTriangles.h"

namespace cagd
{
    // default/special constructor
    PascalTriangle::PascalTriangle(int order): TriangularMatrix<double>(order + 1)
    {
        _data[0][0] = 1.0;

        for (int k = 1; k <= order; k++)
        {
            _data[k][0] = _data[k][k] = 1.0;

            #pragma omp parallel for
            for (int l = 1; l <= k / 2; l++)
            {
                _data[k][l]     = _data[k - 1][l - 1] + _data[k - 1][l];
                _data[k][k - l] = _data[k][l];
            }
        }
    }
}
