#pragma once

#include "HCoordinates3.h"
#include "RealMatrices.h"

namespace cagd
{
    class GeometryHelper
    {
    public:
        static HCoordinate3 transformPoint(const HCoordinate3 &point, const RealMatrix &transform);
        static double distanceFromLine(HCoordinate3 point, HCoordinate3 linePoint1, HCoordinate3 linePoint2);
        static RealMatrix generateTranslationMatrix(DCoordinate3 translationVector);
        static RealMatrix rotationAroundOy(double radians);
        static RealMatrix rotationAroundOx(double radians);
        static RealMatrix inverse(const RealMatrix &matrix);
    };
}
