#include "GeometryHelper.h"
#include "RealMatrixDecompositions.h"

namespace cagd
{
    HCoordinate3 GeometryHelper::transformPoint(const HCoordinate3 &point, const RealMatrix &tr)
    {
        return HCoordinate3(
            (GLfloat) (tr(0,0)*point[0] + tr(0,1)*point[1] + tr(0,2)*point[2] + tr(0,3)*point[3]),
            (GLfloat) (tr(1,0)*point[0] + tr(1,1)*point[1] + tr(1,2)*point[2] + tr(1,3)*point[3]),
            (GLfloat) (tr(2,0)*point[0] + tr(2,1)*point[1] + tr(2,2)*point[2] + tr(2,3)*point[3]),
            (GLfloat) (tr(3,0)*point[0] + tr(3,1)*point[1] + tr(3,2)*point[2] + tr(3,3)*point[3]));
    }

    double GeometryHelper::distanceFromLine(HCoordinate3 point, HCoordinate3 linePoint1, HCoordinate3 linePoint2)
    {
        linePoint2 -= linePoint1;
        point -= linePoint1;
        return (linePoint2 ^ point).length() / linePoint2.length();
    }

    RealMatrix GeometryHelper::generateTranslationMatrix(DCoordinate3 translationVector)
    {
        RealMatrix output(4,4);
        output.loadIdentityMatrix();

        output(0,3) = translationVector.x();
        output(1,3) = translationVector.y();
        output(2,3) = translationVector.z();

        return output;
    }

    RealMatrix GeometryHelper::rotationAroundOy(double radians)
    {
        RealMatrix result(4,4);
        result.loadNullMatrix();

        result(1, 1) = result(3, 3) = 1;
        result(0, 0) = result(2, 2) = std::cos(radians);
        result(0, 2) = std::sin(radians);
        result(2, 0) = - result(0, 2);

        return result;
    }

    RealMatrix GeometryHelper::rotationAroundOx(double radians)
    {
        RealMatrix result(4,4);
        result.loadNullMatrix();

        result(0, 0) = result(3, 3) = 1;
        result(1, 1) = result(2, 2) = std::cos(radians);
        result(1, 2) = - std::sin(radians);
        result(2, 1) = - result(1, 2);

        return result;
    }

    RealMatrix GeometryHelper::inverse(const RealMatrix &matrix)
    {
        unsigned n = matrix.rowCount();
        RealMatrix result(n, n);
        RealMatrix eye(n, n);
        eye.loadIdentityMatrix();

        PLUDecomposition decomp(matrix);
        decomp.solveLinearSystem(eye, result);

        return result;
    }
}
