#pragma once

#include "PascalTriangles.h"
#include <limits>

namespace cagd
{
    const double         PI             = 3.1415926535897932384626433832795;
    const double         TWO_PI         = 2.0 * PI;
    const double         HALF_PI        = PI / 2.0;
    const double         DEG_TO_RADIAN  = PI / 180.0;
    const double         EPS            = 1.0e-9;
    const double         MACHINE_EPS    = std::numeric_limits<double>::epsilon();
    const double         TINY           = std::numeric_limits<double>::min();

    const int            BC_SIZE        = 500;
    const PascalTriangle BC(BC_SIZE);

    namespace variable
    {
        enum Type{U = 0, V = 1};
    }
}
